#include "mainwindow.h"
#include "ui_mainwindow.h"
#include <QStringList>

MainWindow::MainWindow(QWidget *parent)
    : QMainWindow(parent)
    , ui(new Ui::MainWindow)
{
    ui->setupUi(this);

    // graphs settings
    series1 = new QtCharts::QLineSeries();
    series2 = new QtCharts::QLineSeries();
    series3 = new QtCharts::QLineSeries();
    // marker settings
    series_marker = new QtCharts::QScatterSeries();
    series_marker->setMarkerShape(QtCharts::QScatterSeries::MarkerShapeCircle);
    series_marker->setMarkerSize(12.0);

    // axses settings
    chart = new QtCharts::QChart(); //a chart is created
    chart2 = new QtCharts::QChart();
    chart->addSeries(series1);
    chart2->addSeries(series2);
    chart2->addSeries(series3);
    chart2->addSeries(series_marker);

    chart->createDefaultAxes();
    chart->setTitle("Signal");
    chart2->createDefaultAxes();
    chart2->setTitle("FFT");

    chart->legend()->setVisible(true);
    chart->legend()->setAlignment(Qt::AlignBottom);
    chart2->legend()->setVisible(true);
    chart2->legend()->setAlignment(Qt::AlignBottom);

    chart->series().at(0)->attachedAxes().at(0)->setRange(0,255);
    chart->series().at(0)->attachedAxes().at(1)->setRange(0,1024);
    chart2->series().at(0)->attachedAxes().at(0)->setRange(0,128);
    chart2->series().at(0)->attachedAxes().at(1)->setRange(0,250);

    //thema settings
    QtCharts::QChartView *chartView = new QtCharts::QChartView(chart);    
    QtCharts::QChartView *chartView2 = new QtCharts::QChartView(chart2);
    chartView->setRenderHint(QPainter::Antialiasing);
    chartView2->setRenderHint(QPainter::Antialiasing);

    ui->horizontalFrame->layout()->addWidget(chartView);
    ui->horizontalFrame->layout()->addWidget(chartView2); //Frame can be change size
    chart->setTheme(QtCharts::QChart::ChartThemeBlueCerulean);
    chart2->setTheme(QtCharts::QChart::ChartThemeBlueCerulean);

    QPen pen1 = series1->pen();
    pen1.setWidth(2);
    pen1.setBrush(QColor(206,255,0));    //signal color lime
    series1->setPen(pen1);
    series1->setName("samples");

    QPen pen2 = series2->pen();
    pen2.setWidth(2);
    pen2.setBrush(QColor(255,0,0));     //fft
    series2->setPen(pen2);
    series2->setName("FFT");

    QPen pen3 = series3->pen();
    pen3.setWidth(2);
    pen3.setBrush(QColor(69,87,245));      //threshold
    series3->setPen(pen3);
    series3->setName("Threshold");

    QPen pen4 = series_marker->pen();
    pen4.setWidth(2);
    pen4.setBrush(QColor(0,0,0));    //color marker
    series_marker->setPen(pen4);
    series_marker->setColor(QColor(255,255,255));
    series_marker->setName("max peak");

    // create object class serialread//
    mySerial1 = new serialread();
    connect(mySerial1,SIGNAL(signalSendDataToPlot(QStringList)),this,SLOT(slotReceiveDataFromSerialRead(QStringList)));
    connect(this,SIGNAL(signalCreateSerialPort(QString)),mySerial1,SLOT(slotCreateSerialPort(QString)));
    connect(this, SIGNAL(signalSetTimer(bool)), mySerial1, SLOT(slotSetTimer(bool)));
    connect(this,SIGNAL(signalDisconnect()),mySerial1,SLOT(slotDisconnect()));

    RefreshComPorts();

    threshold = 17;
    ui->spinBoxThreshold->setValue(threshold);
}

MainWindow::~MainWindow(){

    delete ui;
}

void MainWindow::slotReceiveDataFromSerialRead(QStringList buffer_split){
    if (buffer_split.count() < 256){
        qDebug() << "ERROR";
        return;
    }

    series1->clear();
    for (int i = 0; i < 256 ; i++){
        series1->append(i,buffer_split[i].toInt());
    }
    int32_t DatenarrayR[256];                                            //FFT Datenarray R int32_t
    int32_t DatenarrayI[256];                                            //FFT Datenarray I

    for (int i = 0; i < 256; i++){
        DatenarrayR[i] = buffer_split.at(i).toInt();
        DatenarrayI[i] = 0;
    }

    FFT (DatenarrayR,DatenarrayI,8);                                    //FFT rechnen

    int maxVal = 0;
    int xFromMaxVal = 0;
    int velocity = 0;

    series2->clear();
    series3->clear();
    series_marker->clear();
    ui->number_of_velocity->clear();
    ui->number_of_signal_strength->clear();
    ui->number_of_velocity->setText(QString::number(0));
    ui->number_of_signal_strength->setText(QString::number(0));

    if (ui->checkBoxFilter->isChecked() == true){
        DatenarrayR[1] = 1;
        DatenarrayR[2] = 1;
        DatenarrayR[3] = 1;
        DatenarrayI[1] = 1;
        DatenarrayI[2] = 1;
        DatenarrayI[3] = 1;
    }

    for (int i = 1; i < 128; i++){
        DatenarrayR[i] = sqrt((int32_t)DatenarrayR[i] * (int32_t)DatenarrayR[i] + (int32_t)DatenarrayI[i] * (int32_t)DatenarrayI[i]);

        series2->append(i,DatenarrayR[i]);
        if (DatenarrayR[i] > maxVal){
            maxVal = DatenarrayR[i];
            xFromMaxVal = i;
        }
        if(maxVal > threshold){
            series2->setColor(QColor(255,0,0));
            velocity = xFromMaxVal * 1.578125;
            ui->labelVelocity->setText("velocity: ");

            if(velocity>10){
                ui->number_of_velocity->setText(QString::number(velocity));
                ui->number_of_velocity->setStyleSheet("QLabel { color: red}");
            }
            else{
                ui->number_of_velocity->setText(QString::number(velocity));
                ui->number_of_velocity->setStyleSheet("QLabel { color: black}");
            }

            ui->label_signal_strength->setText("signal strength: ");
            ui->number_of_signal_strength->setText(QString::number(maxVal));
        }

        series3->append(i,threshold);
    }

    if(maxVal > threshold){
        series_marker->append(xFromMaxVal,maxVal);
    }
}

void MainWindow::on_pushButtonConnectSensor1_clicked(){
    if(ui->pushButtonConnectSensor1->text() == "Connect"){
        emit signalCreateSerialPort(ui->comboBoxPorts->currentText());
        emit signalSetTimer(true);
        ui->pushButtonConnectSensor1->setText("Disconnect");
    }
    else{
        emit signalDisconnect();
        ui->pushButtonConnectSensor1->setText("Connect");
    }
}

void MainWindow::on_spinBoxThreshold_valueChanged(int arg1)
{
    threshold = arg1;
}


void MainWindow::on_pushButtonRefresh_clicked()
{
    RefreshComPorts();
}

void MainWindow::RefreshComPorts(){
    ui->comboBoxPorts->clear();
    QSerialPortInfo port;
    QList<QSerialPortInfo> tmpList;

    tmpList = port.availablePorts();

    for (int i = 0; i < tmpList.size(); i++){
        ui->comboBoxPorts->addItem(tmpList.at(i).portName());
    }
}



